
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
public class Heart {
	private BufferedImage img;
	private int x,y,w,h, deltaX, deltaY;
	public Heart(double angle, BufferedImage img){
		this.img=img;
		w=200;
		h=200;
		x=400;
		y=450;
		deltaX=(int)Math.round(10*Math.cos(angle));
		deltaY=(int)Math.round(10*Math.sin(angle));
	}
	public boolean touches(Rectangle2D object){
		return object.intersects(x, y, w, h);
	}
	public void move(){
		w=95*w/100;
		h=95*h/100;
		x+=deltaX;
		y-=deltaY;
	}
	public void draw(Graphics g){
		g.drawImage(img, x-w/2, y-h/2, x+w/2, y+h/2, 0, 0, img.getWidth(), img.getHeight(), null);
	}
	public int getY(){
		return y;
	}
	public Rectangle2D area(){
		return new Rectangle2D.Double(x-w/2, y-h/2, w, h);
	}
}